VPScriptSuperMenuTitle = "Select"
VPScriptMenuTitle = "Next <# #> Placeholder"
VPShortcutKey = "/"
VPShortcutMask = "control"

MYNSNotFound = 0x7fffffff
MYNSCaseInsensitiveSearch = 1

def main(windowController, *args, **kwargs):
    textView = windowController.textView()
    s = textView.textStorage().mutableString()
    
    # look for placeholder-start marker after end of current selection
    selRange = textView.selectedRange()
    endOfSelRange = selRange.location + selRange.length
    
    r1 = s.rangeOfString_options_range_('<#', MYNSCaseInsensitiveSearch, (endOfSelRange, s.length() - endOfSelRange))
    
    if ( r1.location == MYNSNotFound ):
        r1 = s.rangeOfString_('<#')
    if( r1.location == MYNSNotFound ):
        return
    
    # 1 is NSCaseInsensitiveSearch
    r2 = s.rangeOfString_options_range_('#>', MYNSCaseInsensitiveSearch, (r1.location + r1.length, s.length() - (r1.location + r1.length)))
    
    r = (r1.location, (r2.location + r2.length) - r1.location)
    textView.setSelectedRange_(r)
    